local _ = function(str)
	return str
end

dir = options.dir;

localizedName	= _('Caucasus')
name            = 'Caucasus'
image 			=  dir..'map.png'
description		= _('This region along the eastern Black Sea consists of Russian, Georgian, and Turkish territory. This area includes many airbases, urban areas, lines of communications, and all four seasons.')

nodesFile 		= 'MissionGenerator/nodes.lua'
nodesMapFile 	= 'MissionGenerator/nodesMap.png'
nodesMapBorders	= {-410000, 120000, 18000, 940000}

-- read "local" options
require('lfs')
if lfs.attributes(dir.."local.cfg.lua", 'mode') == 'file' then
	dofile(dir.."local.cfg.lua");
end

edterrainVersion = 3.0
standDescriptionVersion = 1;
 
--MapCoordsFile = dir.."MapCoords.lua";
MapCoordsFile = dir.."MapCoordsUTM.lua"; -- use this for GlobalMapper operations

dofile(MapCoordsFile);

defaultcamera = {-350, 2, 623};		-- batumi


Bookmarks = 
{
	batumi = {-350, 2, 623},	
	sukhumi = {-220, 2, 565},	
	senaki = {-281, 0.2, 647},	
	nalchik = {-124, 0.5, 760},	
	bag = {-15.78, 2, 289.9},	
	trees = {-350, 2, 630},
	Lochini = {-315.6, 2, 896.4},
	Vaziani = {-319.07, 2, 903.15},
	Beslan = {-148.16, 2, 842.834},	
};

SW_bound = {-600, 0, -560};
NE_bound = { 380, 0, 1130};

defaultBullseye =
{
	blue = {x = -291014,  y = 617414},
	red	 = {x = 11557, y = 371700},
};

landfile3 = dir.."Surface/land.lsa3";

if options.quality == "high" then
	--districtsfile = dir.."Scenes/districts.dstr";
	--blocksdir = dir.."Structures/blocks";
	districtsfile = dir.."Scenes/new2/districts.dstr";
	blocksdir = dir.."Structures/blocks/new2";
	BinScene3 = dir.."Scenes/high.scn3";
end
if options.quality == "medium" then
	districtsfile = dir.."Scenes/new2/districts.dstr";
	blocksdir = dir.."Structures/blocks/new2";
	BinScene3 = dir.."Scenes/low.scn3";
end
if options.quality == "low" then
	BinScene3 = dir.."Scenes/low.scn3";
end


modelspreview = dir.."Structures/Preview";
modelsproxy = dir.."Structures/Preview/proxy.ofsh";
smallshitdir = dir.."Structures/SmallShit/";

smallshit =
{
	heightMapSize = 512;
	files = 
	{
		{
			name = "grass";
			texture = "SmallShit_Grass.dds";
			slope = 0.8;
			slopeDelta = 0.3;		
			layers =
			{
				{
					squareSize = 150.0;
					scale = 1.0;			
				},
				{
					squareSize = 20.0;
					scale = 1.0;			
				},
				{
					squareSize = 10.0;
					scale = 0.8;			
				}
			};		
		}
	}
}

shapetables = 
{
	dir.."Structures/StructTable.sht"
}
modelsdirectory = 
{
	dir.."Structures/High/EDM"
}

blocks = 
{
	dir.."Structures/blocks/Comfort.blk",
	dir.."Structures/blocks/zavod256.blk",
	dir.."Structures/blocks/Factory-1.blk",
	dir.."Structures/blocks/poselki_gorn.blk",
	dir.."Structures/blocks/Town_1.blk",
	dir.."Structures/blocks/Town_2.blk",
	dir.."Structures/blocks/Town_3.blk",
	dir.."Structures/blocks/Village_1.blk",
	dir.."Structures/blocks/Village_2.blk",
	dir.."Structures/blocks/Village_3.blk",
	dir.."Structures/blocks/Village_4.blk",
	dir.."Structures/blocks/Village_5.blk",
	dir.."Structures/blocks/Village_6.blk",
	dir.."Structures/blocks/Village_7.blk",
	dir.."Structures/blocks/Village_8.blk",
	dir.."Structures/blocks/Village_9.blk",
	dir.."Structures/blocks/Village_10.blk",
	dir.."Structures/blocks/Village_11.blk",
	dir.."Structures/blocks/Village_12.blk",
	dir.."Structures/blocks/Village_13.blk",
	dir.."Structures/blocks/Village_14.blk",
	dir.."Structures/blocks/Village_15.blk",
	dir.."Structures/blocks/Village_16.blk",
	dir.."Structures/blocks/Village_18.blk",
	dir.."Structures/blocks/Village_19.blk",
	dir.."Structures/blocks/Village_20.blk",
	dir.."Structures/blocks/Village_21.blk",
}


-- 
-- vfs textures for land!
-- 
vfstextures = 
{
	dir.."vfstextures/LandTextures",
	dir.."vfstextures/MapTextures",
	dir.."vfstextures/Buildings_textures",
	dir.."vfstextures/AirfieldsTexturesSum",
}

local function get_plugin_option_val(options_plugin_name,option_name)

  dofile(lfs.writedir().."Config\\".."options.lua")
  
  local CNCPT = options["plugins"][options_plugin_name]
  local CNCPText = "default"
  if CNCPT == nil then
    CNCPText = "default"
  else
    CNCPText = options["plugins"][options_plugin_name][option_name]
    if CNCPText == nil then
      CNCPText = "default"
    end
  end
  return CNCPText
end

local function get_terrain_setting_from_plugin(options_plugin_name,option_name,def) --multi aircraft per module 
	local  option_name = option_name or "CPLocalList"
	local  livery      = def or "default"
	local  CNCPText    = get_plugin_option_val(options_plugin_name,option_name)
  
	return CNCPText or livery
end


if options.season == "summer" or options.season == "" then
    table.insert(vfstextures, dir.."vfstextures/LandTexturesSummer");
    table.insert(vfstextures, dir.."vfstextures/LandTexturesSummerOther");
    table.insert(vfstextures, dir.."vfstextures/AirfieldBatumiTexturesSum");
    
    local customT  = get_terrain_setting_from_plugin('Caucasus','CPList_Summer');
    local customTO = get_terrain_setting_from_plugin('Caucasus','CPList_SummerO');
    if customT and customT ~= '' and customT ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customT);
    end
    if customTO and customTO ~= '' and customTO ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customTO);
    end
    
end

if options.season == "winter" then
    table.insert(vfstextures, dir.."vfstextures/LandTexturesWinter");
    table.insert(vfstextures, dir.."vfstextures/LandTexturesWinterOther");
    table.insert(vfstextures, dir.."vfstextures/AirfieldBatumiTexturesWin");
    
    local customT  = get_terrain_setting_from_plugin('Caucasus','CPList_Winter');
    local customTO = get_terrain_setting_from_plugin('Caucasus','CPList_WinterO');
    if customT and customT ~= '' and customT ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customT);
    end
    if customTO and customTO ~= '' and customTO ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customTO);
    end
    
end

if options.season == "spring" then
    table.insert(vfstextures, dir.."vfstextures/LandTexturesSpring");
    table.insert(vfstextures, dir.."vfstextures/LandTexturesSpringOther");
    table.insert(vfstextures, dir.."vfstextures/AirfieldBatumiTexturesSpr");
    
    local customT  = get_terrain_setting_from_plugin('Caucasus','CPList_Spring');
    local customTO = get_terrain_setting_from_plugin('Caucasus','CPList_SpringO');
    if customT and customT ~= '' and customT ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customT);
    end
    if customTO and customTO ~= '' and customTO ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customTO);
    end
    
end

if options.season == "autumn" then
    table.insert(vfstextures, dir.."vfstextures/LandTexturesAutumn");
    table.insert(vfstextures, dir.."vfstextures/LandTexturesAutumnOther");
    table.insert(vfstextures, dir.."vfstextures/AirfieldBatumiTexturesAut");
    
    local customT  = get_terrain_setting_from_plugin('Caucasus','CPList_Autumn');
    local customTO = get_terrain_setting_from_plugin('Caucasus','CPList_AutumnO');
    if customT and customT ~= '' and customT ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customT);
    end
    if customTO and customTO ~= '' and customTO ~= 'default' then
      table.insert(vfstextures, dir.."vfstextures/"..customTO);
    end
    
end


local customT1 = get_terrain_setting_from_plugin('Caucasus','CPList_LandT');
local customT2 = get_terrain_setting_from_plugin('Caucasus','CPList_Building');

if customT1 and customT1 ~= '' and customT1 ~= 'default' then
  table.insert(vfstextures, dir.."vfstextures/"..customT1);
end
if customT2 and customT2 ~= '' and customT3 ~= 'default' then
  table.insert(vfstextures, dir.."vfstextures/"..customT2);
end

    
-- 
-- ROADS
-- 
roadfolder = dir.."Roads";
airroadfolder = dir.."VPP";

roads3 = 
{
	road1 = 
	{
		path = dir.."Roads/roads.rn3";
		type = dir.."road3";
	},
	road2 = 
	{
		path = dir.."Roads/rails.rn3";
		type = dir.."road3";
	}
}

routes3 = dir..'Routes/routes.r3';

superficial3 = 
{
	dir.."Onlay/Onlay_SurfaceOnlay.sup3",
	dir.."Roads/Rails.rn3.sup3",
	dir.."Roads/Roads.rn3.sup3",
	dir.."Onlay/Onlay_Airfields.sup3",
	dir.."Onlay/Onlay_CoastlineAll.sup3",
	dir.."Onlay/Onlay_FieldsEdges_CaucNorth.sup3",
	dir.."Onlay/Onlay_FieldsEdges_GeorgOset.sup3",
	dir.."Onlay/Onlay_FieldsEdges_NCauc.sup3",
	dir.."Onlay/Onlay_Rivers_Banks.sup3",
	dir.."Onlay/Onlay_TownsAll.sup3",
	dir.."Onlay/Onlay_Seabed.sup3",
	dir.."Onlay/Onlay_Forests.sup3",
	--Airfields
	dir.."Airfields/Anapa/Anapa_Airfield.sup3",
	dir.."Airfields/Gelendzhik/Gelendzhik_airfield.sup3",
	dir.."Airfields/Gudauta/Gudauta_airfield.sup3",
	dir.."Airfields/Novorossiysk/Novorossiysk_airfield.sup3",
	dir.."Airfields/Senaki/Senaki.sup3",
	dir.."Airfields/Senaki/Senaki_Onlay.sup3",
	dir.."Airfields/Batumi/batumi.sup3",
	dir.."Airfields/Batumi/batumi_onlay.sup3",
	dir.."Airfields/Sukhumi/Sukhumi.sup3",
	dir.."Airfields/Sukhumi/sukhumi_airfield_onlay.sup3",
	dir.."Airfields/Lochini/Lochini.sup3",
	dir.."Airfields/Lochini/Lochini_Onlay.sup3",
	dir.."Airfields/Vaziani/Vaziani.sup3",
	dir.."Airfields/Vaziani/Vaziani_Onlay.sup3",
	dir.."Airfields/Mozdok/Mozdok.sup3",
	dir.."Airfields/Mozdok/Mozdok_Onlay.sup3",
	dir.."Airfields/Beslan/Beslan.sup3",
	dir.."Airfields/Beslan/Beslan_Onlay.sup3",	
	dir.."Airfields/TbilisiMilitary/TbilisiMilitary.sup3",
	dir.."Airfields/TbilisiMilitary/TbilisiMilitary_Onlay.sup3",
}

map3 = 
{
	dir.."Map/mgrs35.sup3",
	dir.."Map/mgrs36.sup3",
	dir.."Map/mgrs37.sup3",
	dir.."Map/mgrs38.sup3",
	dir.."Map/geogrid.sup3",
	dir.."Map/Land_Map_L0.sup3",
	dir.."Map/Land_Map_L2.sup3",
	dir.."Map/Map_Rivers.sup3",
	dir.."Map/map_towns.sup3",
	dir.."Map/Map_LEP.sup3",
	dir.."Map/MAP_horizontal.sup3",
	dir.."Map/Map_Forests.sup3",
	dir.."Map/map_airfields.sup3",
}
map3_ME = 
{
}

if options.lang == "russian" or options.lang == "ru" then
	table.insert(map3, dir.."Map/map_towns_names-ru.sup3");
else
	table.insert(map3, dir.."Map/map_towns_names-en.sup3");
end


LModelFiles = 
{
    lmf = dir.."Structures/model.lm";
    lmf = dir.."Structures/land_offside_model.lm";
}

civilianActivities = dir.."Routes";

NavData = 
{
	graphfile   = dir.."NavData/NavGraph.dat",
	meshfile    = dir.."NavData/NavMesh.dat",
	sqinfofile  = dir.."NavData/SquaresInfo.dat",
}                                                    
id = "Caucasus"

beacons   			   = dir.."Beacons.lua"
towns				   = dir.."Towns.lua"
magnetic_variation     = dir.."MagVar.lua"
TAD_chart_map_set_file = dir.."A-10C/Maps/MFCD_page_TAD_CHART_DEFAULT_MAP_SET.lua"
TAD_vfs_archives       = {
	dir.."A-10C/Maps/TAD_COLLECTION"
}

ABRIS_data_path 	   = dir.."Ka-50/ABRIS/"
weather                = dir.."Weather.lua"
KNEEBOARD 			   = dir.."Kneeboard"



-- Список аэродромов
Khersones         	= 1  -- Херсонес
Saki              	= 2  -- Саки
Simpheropol       	= 3  -- Симферополь гражданский
Razdolnoe         	= 4  -- Раздольное 
Dzhankoy          	= 5  -- Джанкой
Kirovskoe         	= 6  -- Кировское
Kerch             	= 7  -- Багерово (Керчь)
Belbek          	= 8  -- Бельбек
Krasnogvardeyskoye  = 9  -- Красногвардейское
Octyabrskoe         = 10 -- Октябрьское
Gvardeyskoe         = 11 -- Симферополь военный
Anapa      			= 12 -- Анапа
Krasnodar     		= 13 -- Краснодар гражданский
Novorossiysk    	= 14 -- Новороссийск
Krymsk        		= 15 -- Крымск
Maykop        		= 16 -- Майкоп
Gelendzhik      	= 17 -- Геленджик
Sochi       		= 18 -- Сочи (Адлер)
Krasnodar_P     	= 19 -- Краснодар 
Sukhumi       		= 20 -- Сухуми
Gudauta       		= 21 -- Гудаута
Batumi        		= 22 -- Батуми
Senaki  	   		= 23 -- Сенаки
Kobuleti      		= 24 -- Кобулети
Kutaisi       		= 25 -- Кутаиси
MinVody             = 26 -- Минводы
Nalchick       		= 27 -- Нальчик
Mozdok				= 28 -- Моздокский аэродром
Lochini				= 29 -- Гражданский аэропорт в Тбилиси
TbilisiMilitary		= 30 -- Военный аэродром Тбилиси
Vaziani				= 31 -- Военный аэродром Вазиани
Beslan				= 32 -- Владикавказ-Беслан


local towerObjectModels = {"KDP_BIG", "KDP", "Zil_SKP-11", "KP_UG", "HMMWV_M1025","batumi_KDP","airbase_kdp_tbilisi", "airport_babushara_old"}        			

local frequency = {
	first = function(self)
		return self.value, self.modulation
	end,
	next = function(self)
		self.value = self.value + self.step
		return self.value, self.modulation
	end,
	value 	= 121000000,
	step	= 1000000
}

local german_frequency = {
	first = function(self)
		return self.value, self.modulation
	end,
	next = function(self)
		self.value = self.value + self.step
		return self.value, self.modulation
	end,
	value 	= 38400000,
	step	= 200000
}

local fifties_frequency = {
	first = function(self)
		return self.value, self.modulation
	end,
	next = function(self)
		self.value = self.value + self.step
		return self.value, self.modulation
	end,
	value 	= 250000000,
	step	= 1000000
}

local VVS_WW2_frequency = {
	first = function(self)
		return self.value, self.modulation
	end,
	next = function(self)
		self.value = self.value + self.step
		return self.value, self.modulation
	end,
	value 	= 3.75 * 1e6,
	step	= 50  * 1000
}

local assign_frequency = {
	first = function()
		return {frequency:first(),german_frequency:first(),fifties_frequency:first(),VVS_WW2_frequency:first()}
	end,
	next = function()
		return {frequency:next(),german_frequency:next(),fifties_frequency:next(),VVS_WW2_frequency:next()}
	end
}

local modulation = 0

Airdromes = {
--[[
	[Khersones] = {
		names = { en = _("Khersones"), ru = "Херсонес",	},
		code = "UKFH", --realy unknown
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."KHERSONES.rn",
		default_camera_position = {	pnt = {-61729.172,	110.0, -68106.453},		bearing  =  145.0,},-- 0 Херсонес
		base_displacement = { landing = {x = 50.0,  z =-125.0},takeoff = {x = 270.0,  z = 110.0}},--1,   Херсонес
		hel_terminals_number  = 13,
	},
	[Saki] = {
		names = { en = _("Saki"), ru = "Саки",		},		
		code = "UKFI",
		callsign = { _("callsign CALLSIGN_2"), "CALLSIGN_2" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."SAKI.rn",
		default_camera_position = {	pnt = {-5163.503,		150.0, -52801.59},	bearing  =  128.8,},-- 1 Саки
		base_displacement = { landing = {x =750.0,  z = 610.0},takeoff = {x =   0.0,  z = 170.0}},--2,   Саки
		hel_terminals_number  = 63,
	},
	[Simpheropol] = {
		names = { en = _("Simferopol"), ru = "Симферополь",		},
		code = "UKFF",
		callsign = { _("callsign CALLSIGN_3"), "CALLSIGN_3" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."SIMFEROPOL.rn",
		civilian = true,
		default_camera_position = {	pnt = {-9154.209,		160.0, -22654.078},	bearing  =  151.9,},-- 2 Симферополь
		base_displacement = { landing = {x =  0.0,  z = -50.0},takeoff = {x = 400.0,  z = 110.0}},--3,   Симферополь гражданский
		hel_terminals_number  = 37,
	},
	[Razdolnoe] = {
		names = { en = _("Razdolnoye"), ru = "Раздольное",		},
		code = "UKFZ", --realy unknown
		callsign = { _("callsign CALLSIGN_4"), "CALLSIGN_4" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."RAZDOLNOE.rn",
		default_camera_position = {	pnt = { 67870.609,	150.0, -59135.027},		bearing  =  186.9,},-- 3 Раздольное
		base_displacement = { landing = {x =  0.0,  z =   0.0},takeoff = {x = 100.0,  z = -50.0}},--4,   Раздольное
		hel_terminals_number  = 61,
	},
	[Dzhankoy] = {
		names = { en = _("Dzhankoy"), ru = "Джанкой",		},
		code = "UKFY",
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."DJANKOJ.rn",
		civilian = true,
		default_camera_position = {	pnt = { 63676.871,	150.0,	10661.475},		bearing  =  151.0,},-- 4 Джанкой
		base_displacement = { landing = {x =  0.0,  z =   0.0},takeoff = {x =   0.0,  z = -50.0}},--5,   Джанкой
		hel_terminals_number  = 49,
	},
	[Kirovskoe] = {
		names = { en = _("Kirovskoye"), ru = "Кировское",	},
		code = "UKFV", --realy unknown
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."KIROVSKOYE.rn",
		default_camera_position = {	pnt = { 5854.971,		190.0,	72211.555},	bearing  =  82.8,},-- 5 Кировское
		base_displacement = { landing = {x =  0.0,  z = 110.0},takeoff = {x = 100.0,  z = -50.0}},--6,   Кировское
		hel_terminals_number  = 61,
	},
	[Kerch] = {
		names = { en = _("Kerch-Bagerovo"), ru = "Керчь-Багерово",	},
		code = "UKFR",
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."KERCH.rn",
		default_camera_position = {	pnt = { 33940.621,	210.0,	155181.078},	bearing  = 	91.1,},-- 6 Багерово
		base_displacement = { landing = {x =  0.0,  z = -50.0},takeoff = {x = 280.0,  z = 110.0}},--7,   Багерово (Керчь)
		hel_terminals_number  = 65,
	},
	[Belbek] = {
		names = { en = _("Belbek"), ru = "Бельбек",	},
		code = "UKFL",
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."BELBECK.rn",
		civilian = true,
		default_camera_position = {	pnt = {-49501.426,	190.0, -54885.09},		bearing  =  96.6,},-- 7 Бельбек
		base_displacement = { landing = {x =  0.0,  z = -50.0},takeoff = {x =   0.0,  z = 320.0}},--8,   Бельбек
		hel_terminals_number  = 59,
	},
	[Krasnogvardeyskoye] = {
		names = { en = _("Krasnogvardeyskoye"), ru = "Красногвардейское",	},
		code = "UKFK", --realy unknown
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = {"KDP_BIG", "KDP"},
		roadnet = airroadfolder.."/".."KRASNOGVARD.rn",
		default_camera_position = {	pnt = { 50080.523,	150.0,	925.858},		bearing  =  115.9,},-- 8 Красногвардейское
		base_displacement = { landing = {x =614.0,  z = -50.0},takeoff = {x =   0.0,  z = 200.0}},--9,   Красногвардейское
		hel_terminals_number  = 44,
	},
	[Octyabrskoe] = {
		names = { en = _("Octyabrskoye"), ru = "Октябрьское",	},
		code = "UKFO", --realy unknown
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."OKTYABRSKOE.rn",
		default_camera_position = {	pnt = { 21939.803,	150.0, -14006.732},		bearing  =  107.6,},-- 9 Октябрьское
		base_displacement = { landing = {x =190.0,  z = -50.0},takeoff = {x = 700.0,  z = 110.0}},--10,  Октябрьское
		hel_terminals_number  = 61,
	},
	[Gvardeyskoe] = {
		names = { en = _("Gvardeyskoye"), ru = "Гвардейское",	},
		code = "UKFG", --realy unknown
		callsign = { _("callsign CALLSIGN_1"), "CALLSIGN_1" },
		frequency = 127500000.0,
		control_tower = towerObjectModels,
		roadnet = airroadfolder.."/".."GVARDEJSKOE.rn",
		default_camera_position = {	pnt = {-2157.586,		150.0, -23384.529},	bearing  =  152.7,},-- 10 Гвардейское
		base_displacement = { landing = {x =680.0,  z = -50.0},takeoff = {x = 100.0,  z = 110.0}},--11,  Симферополь военный
		hel_terminals_number  = 53,
	},
--]]
	[Anapa] = {
		names = { en = _("Anapa-Vityazevo"), ru = "Анапа-Витязево",	cn = "阿纳帕-维迪泽瓦", es = "Anapa-Vityazevo", }, --this is for MAP!
		code = "URKA",
		callsign = { 
			['Common'] = { _("callsign Anapa"), "Anapa" } --this is for radio communications!
		},
		frequency = assign_frequency.first(),
		modulation = modulation,
		control_tower = towerObjectModels,
		roadnet =  dir.."Airfields/Anapa/taxiway.rn3",
		civilian = true,
		default_camera_position = {	pnt = {-4737.023,		145.0,	242694.906},bearing  =  164.5,},-- 11 Анапа
		base_displacement = { landing = {x =  0.0,  z = 250.0},takeoff = {x =   0.0,  z = 400.0}},--12,  Анапа
		hel_terminals_number  = 43,
		class = 1,
		-- точка привязки аэродрома на карте
		reference_point = {x = -5406.2803440839, y = 243127.2973737},
		projects={"t3:277568","t3:277569"},
		shelters={"t3:277388","t3:277389","t3:277391","t3:277392","t3:277394","t3:277396","t3:277397","t3:277399","t3:277401","t3:277403","t3:277406","t3:277404","t3:277400","t3:277423","t3:277426","t3:277425","t3:277431","t3:277417","t3:277416","t3:277414","t3:277432","t3:277409","t3:277411","t3:277410","t3:277419","t3:277407","t3:277408","t3:277405","t3:277402","t3:277398","t3:277395","t3:277393","t3:277387","t3:277384","t3:277390","t3:277382","t3:277381","t3:277383","t3:277385","t3:277386","t3:277430","t3:277424","t3:277422","t3:277421","t3:277420","t3:277429","t3:277418","t3:277428","t3:277427","t3:277415","t3:277413","t3:277412"},		warehouse={"t3:277494","t3:277495","t3:277496","t3:277498","t3:277344","t3:277346","t3:277347","t3:277348","t3:277349","t3:277352","t3:277340","t3:277341","t3:277350","t3:277351","t3:277336","t3:277337","t3:277339","t3:277338","t3:277342","t3:277345","t3:277343"},
	},
	[Krasnodar] = {
		names = { en = _("Krasnodar-Center"), ru = "Краснодар-Центральный",	cn = "克拉斯诺达尔-中心区", es = "Krasnodar-Center", },
		code = "URKL",
		callsign = {
			['USSR'] = { _("callsign Volokno"), "Volokno" },
			['NATO'] = { _("callsign Krasnodar-Center"), "Krasnodar" }			
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		default_camera_position = {	pnt = {11046.899,		130.0,	367780.875},bearing  =  297.0,},-- 12 Краснодар-Центр
		base_displacement = { landing = {x =  0.0,  z = 300.0},takeoff = {x =   0.0,  z = 500.0}},
		hel_terminals_number  = 50,
		roadnet =  dir.."Airfields/Krasnodar/taxiway.rn3",
		class = 1,
		reference_point = {x = 11692.789495652, y = 367948.47230953},
		projects={"t3:278603","t3:278604"},
shelters={"t3:278511","t3:278512","t3:278513","t3:278510","t3:278509","t3:278508","t3:278504","t3:278503","t3:278502","t3:278506","t3:278507","t3:278505","t3:278500","t3:278497","t3:278496","t3:278498","t3:278499","t3:278501","t3:278515","t3:278514","t3:278516","t3:278517","t3:278518","t3:278519","t3:278520","t3:278521","t3:278522","t3:278523","t3:278524","t3:278525","t3:278526","t3:278527","t3:278528"},
warehouse={"t3:278458","t3:278401","t3:278414","t3:278417","t3:278428","t3:278429","t3:278426","t3:278495","t3:278418","t3:278419","t3:278427","t3:278420","t3:278421","t3:278423","t3:278424","t3:278415","t3:278416","t3:278422","t3:278425"},
	},
	[Novorossiysk] = {
		names = { en = _("Novorossiysk"), ru = "Новороссийск", cn = "新罗西斯克", es = "Novorossiysk", },
		code = "URKN", --realy unknown
		callsign = {
			['USSR'] = { _("callsign Myskhako"), "Myskhako" },
			['NATO'] = { _("callsign Novorossiysk"), "Novorossiysk" }			
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		default_camera_position = {	pnt = {-40432.367,	140.0,	279253.563},	bearing  =  152.5,},-- 13 Новороссийск
		base_displacement = { landing = {x =1400.0, z = -35.0},takeoff = {x =1400.0,  z = -35.0}},--14,  Новороссийск
		single_directional = 1,
		hel_terminals_number  = 23,
		roadnet =  dir.."Airfields/Novorossiysk/taxiway.rn3",
		class = 2,
		reference_point = {x = -40915.496728899, y = 279256.64920952},
		projects={"t3:280310","t3:280311"},
shelters={"t3:280132","t3:280134","t3:280137","t3:280135","t3:280138","t3:280136","t3:280133","t3:280139","t3:280140","t3:280142","t3:280141","t3:280143","t3:280145","t3:280148","t3:280146","t3:280149","t3:280147","t3:280144","t3:280150","t3:280151","t3:280153","t3:280152"},
warehouse={"t3:280237","t3:280111","t3:280112","t3:280108","t3:280109","t3:280106","t3:280110","t3:280113","t3:280103","t3:280107","t3:280101","t3:280102","t3:280104","t3:280105","t3:280114","t3:280115","t3:280116","t3:280127","t3:280218","t3:280219"},
	},
	[Krymsk] = {
		names = { en = _("Krymsk"), ru = "Крымск", cn = "克雷姆斯克", es = "Krymsk", },
		code = "URKW",
		callsign = {
			['USSR'] = { _("callsign Taymyr"), "Taymyr" },
			['NATO'] = { _("callsign Krymsk"), "Krymsk" }			
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		default_camera_position = {	pnt = {-6714.982,		120.0,	294749.531},bearing  =  342.2,},-- 14 Крымск
		base_displacement = { landing = {x =  0.0,  z = 300.0},takeoff = {x =   0.0,  z = 400.0}},--15,  Крымс
		hel_terminals_number  = 50,
		roadnet =  dir.."Airfields/Krymsk/taxiway.rn3",
		class = 1,
		reference_point = {x = -6583.663574989, y = 294383.98405512},
		projects={"t3:279109","t3:279110"},
shelters={"t3:278876","t3:278877","t3:278878","t3:278879","t3:278880","t3:278881","t3:278882","t3:278883","t3:278884","t3:278885","t3:278886","t3:278887","t3:278888","t3:278889","t3:278890","t3:279030","t3:279031","t3:279029","t3:279033","t3:279034","t3:279032","t3:279036","t3:279037","t3:279035","t3:279039","t3:279040","t3:279038"},
warehouse={"t3:278987","t3:278980","t3:278916","t3:278917","t3:278918","t3:278922","t3:278923","t3:278924","t3:278925","t3:278926","t3:278927","t3:278928","t3:279041","t3:278920","t3:278921","t3:278929","t3:278930","t3:278919","t3:278931","t3:278939"},
	},
	[Maykop] = {
		names = { en = _("Maykop-Khanskaya"), ru = "Майкоп-Ханская", cn = "迈科普-汉斯卡亚", es = "Maykop-Khanskaya"  },
		code = "URKH",
		callsign = {
			['USSR'] = { _("callsign Sokrat"), "Sokrat" },
			['NATO'] = { _("callsign Maykop-Khanskaya"), "Khanskaya" }			
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		default_camera_position = {	pnt = {-26871.365,	280.0,	458253.906},	bearing  =  334.7,},-- 15 Майкоп
		base_displacement = { landing = {x =  0.0,  z = 300.0},takeoff = {x =   0.0,  z = 400.0}},--16,  Майкоп
		hel_terminals_number  = 63,
		roadnet =  dir.."Airfields/Maykop/taxiway.rn3",
		class = 1,
		reference_point = {x = -26441.347360305, y = 458040.61422532},
		projects={"t3:279640","t3:279641"},
		shelters={},	warehouse={"t3:279522","t3:279534","t3:279564","t3:279415","t3:279416","t3:279417","t3:279418","t3:279419","t3:279420","t3:279421","t3:279422","t3:279423","t3:279410","t3:279411","t3:279413","t3:279414","t3:279412","t3:279424","t3:279425","t3:279409","t3:279395"},
	},
	[Gelendzhik] = {
		names = { en = _("Gelendzhik"), ru = "Геленджик", cn = "格连吉克", es = "Gelendzhik", },
		code = "URKG", --realy unknown
		callsign = {
			['USSR'] = { _("callsign Maslenka"), "Maslenka" },
			['NATO'] = { _("callsign Gelendzhik"), "Gelendzhik" }			
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		default_camera_position = {	pnt = {-50287.102,	125.0,	298195.469},	bearing  =  156.0,},-- 16 Геленджик
		base_displacement = { landing = {x = 150.0, z = 200.0},takeoff = {x = 550.0,  z =-210.0}},--17,  Геленджик
		single_directional = 1,
		hel_terminals_number  = 34,
		roadnet =  dir.."Airfields/Gelendzhik/taxiway.rn3",
		class = 2,
		reference_point = {x = -50392.648146355, y = 298387.43849386}, 
		projects={"t3:277946","t3:277947"},
		shelters={},
warehouse={"t3:277743","t3:277741","t3:277757","t3:277770","t3:277771","t3:277773","t3:277785","t3:277772","t3:277776","t3:277774","t3:277775","t3:277783","t3:277784","t3:277777","t3:277778","t3:277779","t3:277780","t3:277781","t3:277782","t3:277868"},
	},
	[Sochi] = {
		names = { en = _("Sochi-Adler"), ru = "Сочи-Адлер", cn = "索契-阿德勒",	es = "Sochi-Adler", },
		code = "URSS",
		callsign = {
			['Common'] = { _("callsign Sochi-Adler"), "Sochi" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		default_camera_position = {	pnt = {-164274.344,	130.0,	461912.719},	bearing  =  132.5,},-- 17 Сочи(Адлер)
		base_displacement = { landing = {x = 960.0, z =-200.0},takeoff = {x = 960.0,  z =-270.0}},--18,  Сочи (Адлер)
		single_directional = 0,
		hel_terminals_number  = 28,
		roadnet =  dir.."Airfields/Sochi_Adler/taxiway.rn3",
		class = 1,
		reference_point = {x = -164474.73482633, y = 462236.21834688},
		projects={"t3:280816","t3:280817"},		shelters={"t3:280746","t3:280745","t3:280747","t3:280593","t3:280594","t3:280595","t3:280590","t3:280591","t3:280592","t3:280587","t3:280588","t3:280589","t3:280584","t3:280585","t3:280586","t3:280582","t3:280581","t3:280583","t3:280579","t3:280578","t3:280580","t3:280576","t3:280575","t3:280577","t3:280573","t3:280574","t3:280572"},
warehouse={"t3:280700","t3:280701","t3:280695","t3:280699","t3:280703","t3:280704","t3:280744","t3:280698","t3:280702","t3:280705","t3:280706","t3:280693","t3:280694","t3:280696","t3:280697","t3:280707","t3:280708","t3:280709","t3:280680","t3:280632","t3:280631"},
	},
	[Krasnodar_P] = {
		names = { en = _("Krasnodar-Pashkovsky"), ru = "Краснодар-Пашковский", cn = "克拉斯诺达尔-帕什科夫斯基",	es = "Krasnodar-Pashkovsky", },
		code = "URKK",
		callsign = {
			['USSR'] = { _("callsign Krasnodar"), "Krasnodar" },
			['NATO'] = { _("callsign Krasnodar-Pashkovsky"), "Pashkovsky" }			
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		default_camera_position = {	pnt = {8014.047,		134.0,	386493.688},bearing  =  116.0,},-- 18 Краснодар-Пашковский
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 300.0}},--19,  Краснодар
		hel_terminals_number  = 37,
		roadnet =  dir.."Airfields/Krasnodar_P/taxiway.rn3",
		class = 1,
		reference_point = {x = 7674.038444859, y = 385029.5736699},
		projects={"t3:278809","t3:278808"},
		shelters={},
		warehouse={"t3:278786","t3:278790"},
	},
	[Sukhumi] = {
		names = { en = _("Sukhumi-Babushara"), ru = "Сухуми-Бабушара", cn = "苏呼米-巴布沙拉", es = "Sukhumi-Babushara", },
		code = "UGSS",
		callsign = {
			['USSR'] = { _("callsign Uklad"), "Uklad" },
			['NATO'] = { _("callsign Sukhumi"), "Sukhumi" }			
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = {'airport_babushara_old'},
		civilian = true,
		default_camera_position = {	pnt = {-220014.719,	115.0,	564311.188},	bearing  =  228.0,},-- 19 Сухуми
		base_displacement = { landing = {x =  0.0,  z =-220.0},takeoff = {x =   0.0,  z =-220.0}},--20,  Сухуми
		hel_terminals_number  = 42,
		roadnet =  dir.."Airfields/Sukhumi/taxiway.rn3",
		class = 1,
		modelsDir = dir..'Airfields',
		scenery_data =  
		{
			name		= "Sukhumi";
			--position	={-355387.094, 9.965, 617307.875};		
			--surface 	= dir.."Airfields/Sukhumi/land.lsa3";
			model   	= "Sukhumi/Sukhumi";
		},
		reference_point = {x = -220531.73642658, y = 564387.05872916},
		projects={"t3:280882","t3:280883"},
		shelters={},
		warehouse={},
	},
	[Gudauta] = {
		names = { en = _("Gudauta"), ru = "Гудаута", cn = "古达乌塔", es = "Gudauta", },
		code = "UG23",
		callsign = {
			['USSR'] = { _("callsign Lachuga"), "Lachuga" },
			['NATO'] = { _("callsign Gudauta"), "Gudauta" }			
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		approach_light_systems = {
						{
							runway_number = 33,
							runway_suffix = 0, -- 0 - no suffix, Left/Right/Center -> 1/2/3

							low_glide_path = 2.5,
							slightly_low_glide_path = 2.8,
							on_lower_glide_path = 3.0,
							on_upper_glide_path = 3.0,
							slightly_high_glide_path = 3.2,
							high_glide_path = 3.5,
						},
						{
							runway_number = 15,
							runway_suffix = 0, -- 0 - no suffix, Left/Right/Center -> 1/2/3

							low_glide_path = 2.5,
							slightly_low_glide_path = 2.8,
							on_lower_glide_path = 3.0,
							on_upper_glide_path = 3.0,
							slightly_high_glide_path = 3.2,
							high_glide_path = 3.5,
						}
		},
		default_camera_position = {	pnt = {-196858.828,	121.0,	515831.781},	bearing  =  233.0,},-- 20 Гудаута
		base_displacement = { landing = {x =  0.0,  z = 300.0},takeoff = {x =   0.0,  z = 400.0}},--21,  Гудаута
		hel_terminals_number  = 30,
		roadnet =  dir.."Airfields/Gudauta/taxiway.rn3",
		class = 1,
		reference_point = {x = -196974.19851241, y = 516290.23098695},
		projects={"t3:278157","t3:278156"},
shelters={"t3:278080","t3:278081","t3:278082","t3:278077","t3:278078","t3:278079","t3:278086","t3:278087","t3:278088","t3:278089","t3:278090","t3:278091","t3:278074","t3:278075","t3:278076","t3:278072","t3:278071","t3:278073","t3:278083","t3:278084","t3:278085"},
warehouse={"t3:277964","t3:277970","t3:277972","t3:277976","t3:277977","t3:277978","t3:277979","t3:277980","t3:277986","t3:277987","t3:277985","t3:277989","t3:277981","t3:277983","t3:277984","t3:277990","t3:277991","t3:277982","t3:278070","t3:278052"},
	},
	[Batumi] = {
		names = { en = _("Batumi"), ru = "Батуми", cn = "巴统", es = "Batumi", },
		code = "UGSB",
		callsign = {
			['USSR'] = { _("callsign Druzhinnik"), "Druzhinnik" },
			['NATO'] = { _("callsign Batumi"), "Batumi" }
		},			
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = {'batumi_KDP'},
		civilian = true,
		approach_light_systems = {
			{
				runway_number = 13,
				runway_suffix = 0, -- 0 - no suffix, Left/Right/Center -> 1/2/3

				als_argument = 34, -- holds argument to drive PAPI state

				low_glide_path = 2.5,
				slightly_low_glide_path = 2.8,
				on_lower_glide_path = 3.0,
				on_upper_glide_path = 3.0,
				slightly_high_glide_path = 3.2,
				high_glide_path = 3.5,
			}
		},
		default_camera_position = {	pnt = {-355509.094,	110.0,	617577.938},	bearing  =  216.5,},-- 21 Батуми
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--22, Батуми
		single_directional = 1,
		hel_terminals_number  = 16,	
		modelsDir = dir..'Airfields',
		scenery_data =
		{
			name		= "batumi";
			--position	={-355387.094, 9.965, 617307.875};		
			--surface 	= dir.."Airfields/Batumi/land.lsa3";
			model   	= "Batumi/batumi";
			vfstextures = dir.."Airfields/Batumi/textures";
		},
		roadnet =  dir.."Airfields/Batumi/taxiway.rn3",
		class = 2,
		reference_point = {x = -355692.3067714, y = 617269.96285781},
		projects={"t3:277735","t3:277736"},
		shelters={},
		warehouse={"t3:277606","t3:277607","t3:277608"},
	},
	[Senaki] = {
		names = { en = _("Senaki-Kolkhi"), ru = "Сенаки-Колхи",	cn = "塞纳基-科尔奇", es = "Senaki-Kolkhi", },
		code = "UGKS", --realy unknown
		callsign = {
			['USSR'] = { _("callsign Tzokot"), "Tzokot" },
			['NATO'] = { _("callsign Kolkhi"), "Kolkhi" }
		},		
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		default_camera_position = {	pnt = {-281271.656,	112.0,	647057.438},	bearing  =  118.5,},-- 22 Цхакая
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--23, Цхакая
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Senaki/taxiway.rn3",
		modelsDir = dir..'Airfields',
		scenery_data =
		{
			model   	= "Senaki/Senaki";
		},
		class = 2,
		reference_point = {x = -281713.83114196, y = 647369.87369832},
		projects={"t3:280569","t3:280568"},
shelters={"t3:280446","t3:280447","t3:280448","t3:280494","t3:280450","t3:280451","t3:280493","t3:280449","t3:280490","t3:280492","t3:280491","t3:280489","t3:280479","t3:280482","t3:280452","t3:280453","t3:280454","t3:280455","t3:280456","t3:280459","t3:280458","t3:280457","t3:280461","t3:280462","t3:280464","t3:280466","t3:280467","t3:280465","t3:280463","t3:280480","t3:280539","t3:280485","t3:280484","t3:280487","t3:280488","t3:280486","t3:280483","t3:280481","t3:280474","t3:280472","t3:280470","t3:280469","t3:280471","t3:280473","t3:280478","t3:280475","t3:280476","t3:280477","t3:280543","t3:280468","t3:280460","t3:280495"},
warehouse={"t3:280552","t3:280318","t3:280339","t3:280342","t3:280340","t3:280341","t3:280314","t3:280331","t3:280332","t3:280333","t3:280325","t3:280327","t3:280334","t3:280337","t3:280336","t3:280338","t3:280345","t3:280346","t3:280350","t3:280335","t3:280344"},
	},
	[Kobuleti] = {
		names = { en = _("Kobuleti"), ru = "Кобулети", cn = "科布列季", es = "Kobuleti", },
		code = "UG5X", --realy unknown
		callsign = {
			['Common'] = { _("callsign Kobuleti"), "Kobuleti" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		default_camera_position = {	pnt = {-317802.938,	118.0,	635465.938},	bearing  =  121.0,},-- 23 Кобулети
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--24, Кобулетти
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/KOBULETI/taxiway.rn3",
		class = 2,
		reference_point = {x = -317948.32727306, y = 635639.37385346},
		projects={"t3:278367","t3:278368"},
shelters={"t3:278165","t3:278167","t3:278166","t3:278168","t3:278170","t3:278169","t3:278171","t3:278172","t3:278173","t3:278174","t3:278176","t3:278177","t3:278178","t3:278179","t3:278180","t3:278175"},
warehouse={"t3:278327","t3:278323","t3:278340","t3:278341","t3:278342","t3:278348","t3:278351","t3:278359","t3:278343","t3:278346","t3:278349","t3:278350","t3:278345","t3:278355","t3:278334","t3:278336","t3:278344","t3:278347","t3:278353","t3:278354","t3:278205"},
	},
	[Kutaisi] = {
		names = { en = _("Kutaisi"), ru = "Кутаиси", cn = "库塔伊西", es = "Kutaisi", },
		code = "UGKO",
		callsign = {
			['Common'] = { _("callsign Kutaisi"), "Kutaisi" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		runwayName = {
			[0] = 08,
			[1] = 26,
		},
		default_camera_position = {	pnt = {-284569.750,	145.0,	683788.250},	bearing  =  120.5,},-- 24 Котуаси
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--25, Кутаиси
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/KUTAISI/taxiway.rn3",
		class = 1,
		reference_point = {x = -284889.06283057, y = 683853.75717885},
		projects={"t3:279390","t3:279391"},
shelters={"t3:279301","t3:279302","t3:279303","t3:279304","t3:279305","t3:279306","t3:279307","t3:279308","t3:279309","t3:279310","t3:279311","t3:279312","t3:279313","t3:279314","t3:279315","t3:279316","t3:279317","t3:279318","t3:279319","t3:279320","t3:279321","t3:279322","t3:279323","t3:279324","t3:279325","t3:279326","t3:279327","t3:279328","t3:279329","t3:279330","t3:279331","t3:279332","t3:279333"},
warehouse={"t3:279148","t3:279152","t3:279124","t3:279127","t3:279134","t3:279132","t3:279133","t3:279135","t3:279141","t3:279116","t3:279125","t3:279126","t3:279129","t3:279130","t3:279131","t3:279139","t3:279120","t3:279121","t3:279122","t3:279128","t3:279270"},  
	},
	[MinVody] = {
		names = { en = _("Mineralnye Vody"), ru = "Минеральные Воды", cn = "矿水城", es = "Mineralnye Vody", },
		code = "URMM",
		callsign = {
			['Common'] = { _("callsign Mineralnye Vody"), "Minvody" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--26, Минеральные Воды
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/MinVody/taxiway.rn3",
		class = 1,
		reference_point = {x = -51251.551717591, y = 705718.47981263},
		projects={"t3:279883","t3:279882"},
		shelters={},
warehouse={"t3:279859","t3:279860","t3:279863","t3:279862","t3:279856","t3:279861","t3:279854","t3:279855","t3:279858","t3:279857","t3:279723","t3:279722","t3:279846","t3:279783","t3:279746","t3:279747","t3:279762","t3:279738","t3:279755","t3:279757","t3:279761"},
	},
	[Nalchick] = {
		names = { en = _("Nalchik"), ru = "Нальчик", cn = "纳尔奇克", es = "Nalchik", },
		code = "URMN",
		callsign = {
			['Common'] = { _("callsign Nalchik"), "Nalchik" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--27, Нальчик
		single_directional = 0,
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Nalchik/taxiway.rn3",
		class = 2,
		reference_point = {x = -124921.90954665, y = 760428.0733062},
		projects={"t3:280086","t3:280087"},
		shelters={},
warehouse={"t3:279912","t3:280021","t3:280038","t3:280040","t3:280025","t3:280039","t3:280046","t3:280049","t3:280032","t3:280034","t3:280041","t3:280044","t3:280042","t3:280051","t3:280043","t3:280045","t3:280052","t3:280053","t3:280047","t3:280048","t3:280057"},
	},
	[Mozdok] = {
		names = { en = _("Mozdok"), ru = "Моздок", cn = "莫兹多克", es = "Mozdok",},
		code = "XRMF", --по русски ЬРМФ
		callsign = {
			['USSR'] = { _("callsign Assistent"), "Assistent" },
			['NATO'] = { _("callsign Mozdok"), "Mozdok" }			
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = false,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--28 пока тестово, не уверен
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Mozdok/taxiway.rn3",
		modelsDir = dir..'Airfields',
		scenery_data =  
		{
		model   	= "Mozdok/mozdock_lights";
		},
		class = 1,
		reference_point = {x = -83454.571428571, y = 834453.14285714},
		projects={},
		shelters={},
		warehouse={"t3:281116","t3:281117","t3:281118"},
	},
	[Lochini] = {
		names = { en = _("Tbilisi-Lochini"), ru = "Тбилиси-Лочини",	cn = "第比利斯-罗奇尼", es = "Tbilisi-Lochini", },
		code = "UGTB", --ICAO code
		callsign = {
			['Common'] = { _("callsign Tbilisi-Lochini"), "Lochini" } -- Tbilisi International,
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		approach_light_systems = {
			{
				runway_number = 31,
				runway_suffix = 0, -- 0 - no suffix, Left/Right/Center -> 1/2/3
				als_argument = 34, -- holds argument to drive PAPI state
				low_glide_path = 2.5,
				slightly_low_glide_path = 2.8,
				on_lower_glide_path = 3.0,
				on_upper_glide_path = 3.0,
				slightly_high_glide_path = 3.2,
				high_glide_path = 3.5,
			},
			{
				runway_number = 13,
				runway_suffix = 0, -- 0 - no suffix, Left/Right/Center -> 1/2/3
				als_argument = 34, -- holds argument to drive PAPI state
				low_glide_path = 2.5,
				slightly_low_glide_path = 2.8,
				on_lower_glide_path = 3.0,
				on_upper_glide_path = 3.0,
				slightly_high_glide_path = 3.2,
				high_glide_path = 3.5,
			}
		},
		civilian = true,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--28 пока тестово, не уверен
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Lochini/taxiway.rn3",
		modelsDir = dir..'Airfields',
		scenery_data =  
		{
		model   	= "lochini/lochini";
		},
		class = 1,
		reference_point = {x = -315478.57142857, y = 896538.85714286},
		projects={"t3:281006","t3:281007"},
		shelters={},
		warehouse={"t3:281075","t3:281076","t3:281077","t3:281078","t3:281079","t3:281080","t3:281081"},
	},
	[TbilisiMilitary] = {
		names = { en = _("Soganlug"), ru = "Соганлуг", cn = "索甘卢", es = "Soganlug", },
		code = "UG24", --ICAO code
		callsign = {
			['Common'] = { _("callsign Soganlug"), "Soganlug" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--28 пока тестово, не уверен
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/TbilisiMilitary/taxiway.rn3",
		class = 2,
		reference_point = {x = -317838.57142857, y = 895424.57142858},
		projects={"t3:281000","t3:281001"},
		shelters={},
		warehouse={},
	},
	[Vaziani] = {
		names = { en = _("Vaziani"), ru = "Вазиани", cn = "瓦兹亚尼", es = "Vaziani", },
		code = "UG27", --ICAO code
		callsign = {
			['Common'] = { _("callsign Vaziani"), "Vaziani" }
		},
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = false,
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--28 пока тестово, не уверен
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Vaziani/taxiway.rn3",
		modelsDir = dir..'Airfields',
		scenery_data =  
		{
		model   	= "Vaziani/airfield_vaziani_lights";
		},
		class = 2,
		reference_point = {x = -319069.063, y = 903150.625},
		projects={"t3:280911","t3:280912"},
shelters={"t3:280959","t3:280952","t3:280951","t3:280954","t3:280953","t3:280964","t3:280966","t3:280956","t3:280957","t3:280955","t3:280961","t3:280963","t3:280962","t3:280960","t3:280958","t3:280950","t3:280948","t3:280949","t3:280967","t3:280968","t3:280947","t3:280969","t3:280946","t3:280970","t3:280945","t3:280972","t3:280972","t3:280971","t3:280944","t3:280973","t3:280943","t3:280974","t3:280942","t3:280975","t3:280979","t3:280976","t3:280977","t3:280978","t3:280980","t3:280981","t3:280982","t3:280983","t3:280985","t3:280986","t3:280991","t3:280992","t3:280993","t3:280997","t3:280996","t3:280994","t3:280998","t3:280995","t3:280987","t3:280988","t3:280989","t3:280990","t3:280965","t3:280984"},
		warehouse={"t3:280891","t3:280895"},
	},
	[Beslan] = {
		names = { en = _("Beslan"), ru = "Беслан", cn = "别斯兰", es = "Beslan",  },
		code = "URMO", --ICAO code
		callsign = {
			['USSR'] = { _("callsign Stavok"), "Stavok" },
			['NATO'] = { _("callsign Beslan"), "Beslan" }			
		},		
		frequency = assign_frequency.next(),
		modulation = modulation,
		control_tower = towerObjectModels,
		civilian = true,
		runwayName = {
			[0] = 10,
			[1] = 28,
		},		
		base_displacement = { landing = {x =  0.0,  z = 200.0},takeoff = {x =   0.0,  z = 200.0}},--28 пока тестово, не уверен
		hel_terminals_number  = 16,
		roadnet =  dir.."Airfields/Beslan/taxiway.rn3",
		modelsDir = dir..'Airfields',
		scenery_data =  
		{
		model   	= "Beslan/beslan_airfield_lights";
		},
		class = 1,
		reference_point = {x = -148810.84954665, y = 843756.7533062},
		projects={"t3:281253","t3:281254"},
		shelters={},
		warehouse={"t3:281238"},
	},
}

for airdromeIndex, airdrome in pairs(Airdromes) do
	for moduleName, callsigns in pairs(airdrome.callsign) do
		assert(type(moduleName) == 'string')
	end	
end

function GetHelTerm(id)
    return  Airdromes[id].hel_terminals_number
end 

----------------------------------------------------------------------------------------------------------------------
function GetHelicopterLandingPoint(id,point_number)       
        local  p = Airdromes[id].base_displacement.landing
        local  x = p.x + 50.0 * point_number
        local  z = p.z
        return x,z
end
----------------------------------------------------------------------------------------------------------------------
function GetHelicopterTakeoffPoint(id,point_number)       
        local  p = Airdromes[id].base_displacement.takeoff
        local  x = p.x + 42.0 * (GetHelTerm(id) - point_number)
        local  z = p.z
        return x,z
end
----------------------------------------------------------------------------------------------------------------------



